/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.api.IPos;
import noppes.npcs.api.gui.ICompassData;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.constants.EnumQuestTask;

public class PlayerCompassHUDData
implements ICompassData {
    public String npc = "";
    public String name = "";
    public String title = "";
    public BlockPos pos;
    public boolean show = false;
    private int dimensionId = 0;
    private int range = 5;
    private int type = 0;
    public final double[] screenPos = new double[]{0.15, 0.765};
    public float scale = 1.0f;
    public float incline = 0.0f;
    public float rot = 0.0f;
    public boolean showQuestName = true;
    public boolean showTaskProgress = true;

    public PlayerCompassHUDData() {
        this.pos = new BlockPos(0, 0, 0);
    }

    @Override
    public int getDimensionID() {
        return this.dimensionId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NBTTagCompound getNbt() {
        NBTTagCompound nbtCompass = new NBTTagCompound();
        nbtCompass.func_74778_a("Name", this.name);
        nbtCompass.func_74778_a("Title", this.title);
        nbtCompass.func_74778_a("NPCName", this.npc);
        nbtCompass.func_74783_a("BlockPos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        nbtCompass.func_74768_a("DimensionID", this.dimensionId);
        nbtCompass.func_74768_a("Range", this.range);
        nbtCompass.func_74768_a("Type", this.type);
        nbtCompass.func_74757_a("IsShow", this.show);
        nbtCompass.func_74776_a("Scale", this.scale);
        nbtCompass.func_74776_a("Rotation", this.rot);
        nbtCompass.func_74776_a("Incline", this.incline);
        nbtCompass.func_74773_a("Showed", new byte[]{(byte)(this.showQuestName ? 1 : 0), (byte)(this.showTaskProgress ? 1 : 0)});
        NBTTagList scP = new NBTTagList();
        scP.func_74742_a((NBTBase)new NBTTagDouble(this.screenPos[0]));
        scP.func_74742_a((NBTBase)new NBTTagDouble(this.screenPos[1]));
        nbtCompass.func_74782_a("ScreenPos", (NBTBase)scP);
        return nbtCompass;
    }

    @Override
    public String getNPCName() {
        return this.npc;
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(this.pos);
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isShow() {
        return this.show;
    }

    public void load(NBTTagCompound nbtCompass) {
        this.name = nbtCompass.func_74779_i("Name");
        this.title = nbtCompass.func_74779_i("Title");
        this.npc = nbtCompass.func_74779_i("NPCName");
        int[] p = nbtCompass.func_74759_k("BlockPos");
        if (p.length >= 3) {
            this.pos = new BlockPos(p[0], p[1], p[2]);
        }
        this.setDimensionID(nbtCompass.func_74762_e("DimensionID"));
        this.setRange(nbtCompass.func_74762_e("Range"));
        this.setType(nbtCompass.func_74762_e("Type"));
        this.show = nbtCompass.func_74767_n("IsShow");
        this.scale = nbtCompass.func_74760_g("Scale");
        this.rot = nbtCompass.func_74760_g("Rotation");
        this.incline = nbtCompass.func_74760_g("Incline");
        this.screenPos[0] = nbtCompass.func_150295_c("ScreenPos", 6).func_150309_d(0);
        this.screenPos[1] = nbtCompass.func_150295_c("ScreenPos", 6).func_150309_d(1);
        if (nbtCompass.func_150297_b("Showed", 7)) {
            this.showQuestName = nbtCompass.func_74770_j("Showed")[0] == 1;
            this.showTaskProgress = nbtCompass.func_74770_j("Showed")[1] == 1;
        }
    }

    @Override
    public void setDimensionID(int dimID) {
        if (DimensionManager.isDimensionRegistered((int)dimID)) {
            dimID = 0;
        }
        this.dimensionId = dimID;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public void setNPCName(String npcName) {
        if (npcName != null) {
            this.name = npcName;
        }
    }

    @Override
    public void setPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public void setPos(IPos pos) {
        if (pos != null) {
            this.pos = pos.getMCBlockPos();
        }
    }

    @Override
    public void setRange(int range) {
        if (range < 0) {
            range *= -1;
        }
        if (range > 64) {
            range = 64;
        }
        this.range = range;
    }

    @Override
    public void setShow(boolean show) {
        this.show = show;
    }

    @Override
    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    @Override
    public void setType(int type) {
        if (type < 0) {
            type *= -1;
        }
        if (type > EnumQuestTask.values().length - 1) {
            type %= EnumQuestTask.values().length - 1;
        }
        this.type = type;
    }
}

